package ga.core.individual;

/**
 * Interface for debug info.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
public interface IDebugInfo {

  /**
   * Get a string of the id.
   * 
   * @return Id as string.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public String getIdString();

  /**
   * Get the debug string of the individual. This is usually the genotyp and the
   * fitness.
   * 
   * @return Debug string.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public String getDebugString();

  /**
   * Get a string representation of the genotype.
   * 
   * @return Genotype string.
   * 
   * @since 11.08.2012
   * @author Stephan Dreyer
   */
  public String getGenotypeString();
}
